/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive.io;

import com.reandroid.archive.Archive;
import com.reandroid.archive.ArchiveEntry;
import com.reandroid.archive.InputSource;
import com.reandroid.archive.io.ZipInput;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class ArchiveEntrySource<T extends ZipInput>
extends InputSource {
    private final T zipInput;
    private final ArchiveEntry archiveEntry;

    public ArchiveEntrySource(T zipInput, ArchiveEntry archiveEntry) {
        super(archiveEntry.getSanitizedName());
        this.zipInput = zipInput;
        this.archiveEntry = archiveEntry;
        this.setMethod(archiveEntry.getMethod());
    }

    public T getZipSource() {
        return this.zipInput;
    }

    public ArchiveEntry getArchiveEntry() {
        return this.archiveEntry;
    }

    @Override
    public InputStream openStream() throws IOException {
        boolean compressed = this.isCompressed();
        if (compressed) {
            return this.openInflaterInputStream();
        }
        ArchiveEntry archiveEntry = this.getArchiveEntry();
        return this.getZipSource().getInputStream(archiveEntry.getFileOffset(), archiveEntry.getDataSize());
    }

    private boolean isCompressed() {
        ArchiveEntry archiveEntry = this.getArchiveEntry();
        int method = archiveEntry.getMethod();
        if (method == Archive.STORED) {
            return false;
        }
        if (method == Archive.DEFLATED) {
            return true;
        }
        try {
            byte[] buffer = new byte[1024];
            this.openInflaterInputStream().read(buffer, 0, buffer.length);
            archiveEntry.setMethod(Archive.DEFLATED);
            this.setMethod(Archive.DEFLATED);
            return true;
        }
        catch (Throwable ignored) {
            archiveEntry.setMethod(Archive.STORED);
            this.setMethod(Archive.STORED);
            long s1 = archiveEntry.getSize();
            long s2 = archiveEntry.getCompressedSize();
            if (s1 > s2) {
                archiveEntry.setCompressedSize(s1);
            } else if (s2 > s1) {
                archiveEntry.setSize(s2);
            }
            return false;
        }
    }

    private InputStream openInflaterInputStream() throws IOException {
        ArchiveEntry archiveEntry = this.getArchiveEntry();
        InputStream inputStream = this.getZipSource().getInputStream(archiveEntry.getFileOffset(), archiveEntry.getDataSize());
        return new InflaterInputStream(inputStream, new Inflater(true), 512);
    }

    @Override
    public long getLength() throws IOException {
        return this.getArchiveEntry().getDataSize();
    }

    @Override
    public long getCrc() throws IOException {
        return this.getArchiveEntry().getCrc();
    }
}

