/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive;

import com.reandroid.json.JSONArray;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.StringsUtil;
import com.reandroid.utils.collection.ArrayCollection;
import com.reandroid.utils.collection.ComputeIterator;
import com.reandroid.utils.collection.MergingIterator;
import com.reandroid.utils.collection.SingleIterator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;

public class PathTree<T>
implements Comparable<PathTree<?>>,
Iterable<PathTree<T>>,
JSONConvert<JSONObject> {
    private T item;
    private String name;
    private PathTree<T> parent;
    private final LinkedHashMap<String, PathTree<T>> elementsMap;
    public static final String NAME_path = "path";
    public static final String NAME_elements = "elements";

    public PathTree(T item, String name) {
        this.item = item;
        this.name = name;
        this.elementsMap = new LinkedHashMap();
    }

    public PathTree(String name) {
        this(null, name);
    }

    public PathTree<T> copy() {
        return this.copy(this.getName());
    }

    public PathTree<T> copy(String newName) {
        PathTree<T> pathTree = new PathTree<T>(this.getItem(), newName);
        pathTree.setItem(this.getItem());
        for (PathTree<T> element : this) {
            pathTree.add(element.copy());
        }
        return pathTree;
    }

    public void setName(String name) {
        String old = this.name;
        if (old.equals(name)) {
            return;
        }
        this.name = name;
        PathTree<T> parent = this.parent;
        if (parent != null) {
            parent.elementsMap.remove(old);
            parent.elementsMap.put(name, this);
        }
    }

    public void sort() {
        this.sort(true);
    }

    public void sort(boolean recursive) {
        this.sort(CompareUtil.getComparableComparator(), recursive);
    }

    public void sort(Comparator<? super PathTree<?>> comparator, boolean recursive) {
        LinkedHashMap<String, PathTree<T>> elementsMap = this.elementsMap;
        if (elementsMap.size() == 0) {
            return;
        }
        PathTree[] elements = elementsMap.values().toArray(new PathTree[0]);
        Arrays.sort(elements, comparator);
        elementsMap.clear();
        for (PathTree pathTree : elements) {
            elementsMap.put(pathTree.getName(), pathTree);
        }
        if (!recursive) {
            return;
        }
        for (PathTree pathTree : elements) {
            pathTree.sort(comparator, true);
        }
    }

    public List<PathTree<T>> toList() {
        return ArrayCollection.of(this.elementsMap.values());
    }

    @Override
    public Iterator<PathTree<T>> iterator() {
        return this.elementsMap.values().iterator();
    }

    public Iterator<PathTree<T>> getFiles() {
        Iterator iteratorIterator = ComputeIterator.of(this.iterator(), pathTree -> {
            if (pathTree.isFile()) {
                return SingleIterator.of(pathTree);
            }
            return pathTree.getFiles();
        });
        return new MergingIterator<PathTree<T>>(iteratorIterator);
    }

    public Iterator<T> getFileItems() {
        return ComputeIterator.of(this.getFiles(), PathTree::getItem);
    }

    public int size() {
        return this.elementsMap.size();
    }

    public boolean contains(String name) {
        return this.elementsMap.containsKey(name);
    }

    public PathTree<T> remove(String name) {
        return (PathTree)this.elementsMap.remove(name);
    }

    public PathTree<T> getOrCreate(String name) {
        PathTree<T> pathTree = this.get(name);
        if (pathTree == null) {
            pathTree = new PathTree<T>(name);
            this.add(pathTree);
        }
        return pathTree;
    }

    public PathTree<T> get(String name) {
        return this.elementsMap.get(name);
    }

    public PathTree<T> find(String path) {
        if (path.equals(this.getName())) {
            return this;
        }
        int i = path.indexOf(47);
        if (i >= 0) {
            String name = path.substring(0, ++i);
            path = path.substring(i);
            PathTree<T> pathTree = this.get(name);
            if (pathTree != null && path.length() != 0) {
                return pathTree.find(path);
            }
            return pathTree;
        }
        if (path.length() > 0) {
            return this.get(path);
        }
        return null;
    }

    public PathTree<T> add(String path, T item) {
        int i = path.indexOf(47);
        if (i >= 0) {
            String name = path.substring(0, ++i);
            path = path.substring(i);
            PathTree<T> pathTree = this.getOrCreate(name);
            if (path.length() == 0) {
                super.setItemNonNull(item);
                return pathTree;
            }
            return pathTree.add(path, item);
        }
        if (path.length() > 0) {
            PathTree<T> pathTree = this.getOrCreate(path);
            pathTree.setItem(item);
            return pathTree;
        }
        return this;
    }

    public boolean add(PathTree<T> element) {
        if (element == null) {
            return false;
        }
        element.setParent(this);
        this.elementsMap.put(element.getName(), element);
        return true;
    }

    public T getItem() {
        return this.item;
    }

    public void setItem(T item) {
        this.item = item;
    }

    private void setItemNonNull(T item) {
        if (item != null) {
            this.setItem(item);
        }
    }

    public boolean isDirectory() {
        return this.getName().endsWith("/");
    }

    public boolean isFile() {
        return !this.isDirectory();
    }

    public boolean isRoot() {
        return this.isDirectory() && this.getParent() == null;
    }

    public String getName() {
        return this.name;
    }

    public PathTree<T> getParent() {
        return this.parent;
    }

    public void setParent(PathTree<T> parent) {
        if (parent != this) {
            this.parent = parent;
        }
    }

    public int getDepth() {
        int result = 0;
        for (PathTree<T> parent = this; parent != null && !parent.isRoot(); parent = parent.getParent()) {
            ++result;
        }
        return result;
    }

    private PathTree<?>[] getParentElements() {
        int length = this.getDepth();
        PathTree[] results = new PathTree[length];
        int i = length - 1;
        for (PathTree<T> parent = this; parent != null && !parent.isRoot(); parent = parent.getParent()) {
            results[i] = parent;
            --i;
        }
        return results;
    }

    public String getPath() {
        StringBuilder builder = new StringBuilder();
        PathTree<?>[] elements = this.getParentElements();
        for (int i = 0; i < elements.length; ++i) {
            builder.append(elements[i].getName());
        }
        return builder.toString();
    }

    @Override
    public int compareTo(PathTree<?> pathTree) {
        boolean is_directory = this.isDirectory();
        if (is_directory == pathTree.isDirectory()) {
            String name1 = this.getName();
            String name2 = pathTree.getName();
            if (is_directory) {
                name1 = name1.substring(0, name1.length() - 1);
                name2 = name2.substring(0, name2.length() - 1);
            }
            name1 = StringsUtil.toLowercase(name1);
            name2 = StringsUtil.toLowercase(name2);
            return name1.compareTo(name2);
        }
        return is_directory ? -1 : 1;
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        JSONArray jsonArray = jsonObject.optJSONArray(NAME_elements);
        if (jsonArray == null) {
            return;
        }
        int count = jsonArray.length();
        for (int i = 0; i < count; ++i) {
            JSONObject child = jsonArray.getJSONObject(i);
            String path = child.optString(NAME_path, "");
            String name = PathTree.getName(path);
            PathTree<T> pathTree = this.getOrCreate(name);
            pathTree.fromJson(child);
        }
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(NAME_path, this.getPath());
        JSONArray jsonArray = new JSONArray();
        for (PathTree<T> pathTree : this) {
            jsonArray.put(pathTree.toJson());
        }
        if (!jsonArray.isEmpty()) {
            jsonObject.put(NAME_elements, jsonArray);
        }
        return jsonObject;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PathTree)) {
            return false;
        }
        PathTree pathTree = (PathTree)obj;
        return Objects.equals(this.getName(), pathTree.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return this.getPath();
    }

    public static <T1> PathTree<T1> newRoot() {
        return new PathTree("/");
    }

    public static Iterator<String> sortPaths(Iterator<String> iterator) {
        PathTree pathTree = PathTree.newRoot();
        while (iterator.hasNext()) {
            String path = iterator.next();
            pathTree.add(path, path);
        }
        pathTree.sort();
        return pathTree.getFileItems();
    }

    private static String getName(String path) {
        int i = path.length();
        if (i < 2) {
            return path;
        }
        boolean hasPostfix = false;
        if (path.charAt(--i) == '/') {
            path = path.substring(0, i);
            hasPostfix = true;
        }
        if ((i = path.lastIndexOf(47)) >= 0) {
            path = path.substring(++i);
        }
        if (hasPostfix) {
            path = path + '/';
        }
        return path;
    }
}

