/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.utils;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class StringHelper {
    public static String trueOrNull(Boolean value) {
        if (value == null) {
            return null;
        }
        return StringHelper.trueOrNull((boolean)value);
    }

    public static String trueOrNull(boolean value) {
        if (!value) {
            return null;
        }
        return String.valueOf(true);
    }

    public static List<String> sortAscending(List<String> nameList) {
        Comparator<String> cmp = new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s1.compareTo(s2);
            }
        };
        nameList.sort(cmp);
        return nameList;
    }

    public static void printNameAndValues(StringBuilder builder, String tab, int totalWidth, Object[][] objTable) {
        StringHelper.printNameAndValues(builder, tab, "", totalWidth, objTable);
    }

    public static void printNameAndValues(StringBuilder builder, String tab, String separator, int totalWidth, Object[][] objTable) {
        String[][] table = StringHelper.convertNameAndValue(objTable);
        if (table == null) {
            return;
        }
        int leftWidth = 0;
        for (String[] col : table) {
            int len = col[0].length();
            if (len <= leftWidth) continue;
            leftWidth = len;
        }
        int bnColumns = 0;
        int maxRight = totalWidth - (leftWidth += bnColumns);
        for (int i = 0; i < table.length; ++i) {
            String[] col;
            col = table[i];
            if (i != 0) {
                builder.append("\n");
            }
            StringHelper.printRow(false, builder, tab, leftWidth, maxRight, col[0], separator, col[1]);
        }
    }

    private static String[][] convertNameAndValue(Object[][] table) {
        if (table == null) {
            return null;
        }
        ArrayList<String[]> results = new ArrayList<String[]>();
        for (Object[] objRow : table) {
            String[] row = StringHelper.convertNameAndValueRow(objRow);
            if (row == null) continue;
            results.add(row);
        }
        if (results.size() == 0) {
            return null;
        }
        return (String[][])results.toArray((T[])new String[0][]);
    }

    private static String[] convertNameAndValueRow(Object[] objRow) {
        if (objRow == null) {
            return null;
        }
        int len = objRow.length;
        if (len != 2) {
            return null;
        }
        if (objRow[0] == null || objRow[1] == null) {
            return null;
        }
        String[] result = new String[len];
        result[0] = objRow[0].toString();
        result[1] = objRow[1].toString();
        if (result[0] == null || result[1] == null) {
            return null;
        }
        return result;
    }

    public static void printTwoColumns(StringBuilder builder, String tab, int totalWidth, String[][] table) {
        StringHelper.printTwoColumns(builder, tab, "  ", totalWidth, table);
    }

    public static void printTwoColumns(StringBuilder builder, String tab, String columnSeparator, int totalWidth, String[][] table) {
        int leftWidth = 0;
        for (String[] col : table) {
            int len = col[0].length();
            if (len <= leftWidth) continue;
            leftWidth = len;
        }
        int maxRight = totalWidth - leftWidth;
        for (int i = 0; i < table.length; ++i) {
            String[] col = table[i];
            if (i != 0) {
                builder.append("\n");
            }
            StringHelper.printRow(true, builder, tab, leftWidth, maxRight, col[0], columnSeparator, col[1]);
        }
    }

    private static void printRow(boolean indentLeft, StringBuilder builder, String tab, int leftWidth, int maxRight, String left, String separator, String right) {
        builder.append(tab);
        if (indentLeft) {
            builder.append(left);
        }
        StringHelper.fillSpace(builder, leftWidth - left.length());
        if (!indentLeft) {
            builder.append(left);
        }
        builder.append(separator);
        char[] rightChars = right.toCharArray();
        int rightWidth = 0;
        boolean spacePrefixSeen = false;
        for (int i = 0; i < rightChars.length; ++i) {
            boolean skipFirstSpace;
            char ch = rightChars[i];
            if (i == 0) {
                builder.append(ch);
                ++rightWidth;
                continue;
            }
            if (ch == '\n' || rightWidth > 0 && rightWidth % maxRight == 0) {
                builder.append('\n');
                builder.append(tab);
                StringHelper.fillSpace(builder, leftWidth + separator.length());
                rightWidth = 0;
                spacePrefixSeen = false;
            }
            if (ch == '\n') continue;
            boolean bl = skipFirstSpace = rightWidth == 0 && ch == ' ';
            if (!skipFirstSpace || spacePrefixSeen) {
                builder.append(ch);
                ++rightWidth;
                continue;
            }
            spacePrefixSeen = true;
        }
    }

    private static void fillSpace(StringBuilder builder, int count) {
        for (int i = 0; i < count; ++i) {
            builder.append(' ');
        }
    }
}

