/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.utils;

import java.util.Iterator;

public class CyclicIterator<T>
implements Iterator<T> {
    private final T[] elements;
    private int mIndex;
    private int cycleCount;
    private int count;

    public CyclicIterator(T[] elements) {
        if (elements == null || elements.length == 0) {
            throw new IllegalArgumentException("Elements can not be empty");
        }
        this.elements = elements;
    }

    @Override
    public boolean hasNext() {
        return this.elements.length != 0;
    }

    @Override
    public T next() {
        int i = this.mIndex;
        T item = this.elements[i];
        int length = this.elements.length;
        if (++i >= length) {
            i = 0;
        }
        this.mIndex = i;
        ++this.count;
        if (this.count >= length) {
            this.count = 0;
            ++this.cycleCount;
        }
        return item;
    }

    public int length() {
        return this.elements.length;
    }

    public int getIndex() {
        return this.mIndex;
    }

    public int getCycleCount() {
        return this.cycleCount;
    }

    public void resetCycleCount() {
        this.cycleCount = 0;
        this.count = 0;
    }

    public String toString() {
        return "[cycle = " + this.getCycleCount() + ": " + this.getIndex() + "/" + this.length() + "] " + this.elements[this.mIndex];
    }
}

