/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.smali;

import java.io.File;
import java.util.Comparator;
import java.util.List;

public class SmaliUtil {
    static final String CACHE_DIR = ".cache";

    static void sortDexFiles(List<File> fileList) {
        fileList.sort(new Comparator<File>(){

            @Override
            public int compare(File file1, File file2) {
                int i2;
                int i1 = SmaliUtil.getDexNumber(file1.getName());
                if (i1 == (i2 = SmaliUtil.getDexNumber(file2.getName()))) {
                    return 0;
                }
                if (i1 < 0 || i1 < i2) {
                    return -1;
                }
                return 1;
            }
        });
    }

    static String getDexFileName(int i) {
        if (i == 0) {
            return "classes.dex";
        }
        return "classes" + i + ".dex";
    }

    static boolean isClassesDir(File dir) {
        if (!dir.isDirectory()) {
            return false;
        }
        return SmaliUtil.getDexNumber(dir.getName()) >= 0;
    }

    static int getDexNumber(String name) {
        String ext;
        if (name.equals("classes") || name.equals("classes.dex")) {
            return 0;
        }
        String prefix = "classes";
        if (!name.startsWith(prefix)) {
            return -1;
        }
        if ((name = name.substring(prefix.length())).endsWith(ext = ".dex")) {
            name = name.substring(0, name.length() - ext.length());
        }
        try {
            return Integer.parseInt(name);
        }
        catch (NumberFormatException ignored) {
            return -1;
        }
    }
}

