/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.smali;

import com.reandroid.apk.APKLogger;
import com.reandroid.apk.ApkModuleEncoder;
import com.reandroid.apk.DexEncoder;
import com.reandroid.apkeditor.compile.BuildOptions;
import com.reandroid.apkeditor.smali.SmaliUtil;
import com.reandroid.archive.FileInputSource;
import com.reandroid.archive.InputSource;
import com.reandroid.arsc.chunk.xml.AndroidManifestBlock;
import com.reandroid.dex.model.DexFile;
import com.reandroid.utils.StringsUtil;
import com.reandroid.utils.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jf.smali.Smali;
import org.jf.smali.SmaliOptions;

public class SmaliCompiler
implements DexEncoder {
    private final BuildOptions buildOptions;
    private APKLogger apkLogger;
    private Integer minSdkVersion;

    public SmaliCompiler(BuildOptions buildOptions) {
        this.buildOptions = buildOptions;
    }

    @Override
    public List<InputSource> buildDexFiles(ApkModuleEncoder apkModuleEncoder, File mainDir) throws IOException {
        File smaliDir = new File(mainDir, "smali");
        if (!smaliDir.isDirectory()) {
            return null;
        }
        AndroidManifestBlock manifestBlock = apkModuleEncoder.getApkModule().getAndroidManifest();
        if (manifestBlock != null) {
            this.minSdkVersion = manifestBlock.getMinSdkVersion();
        }
        if (this.minSdkVersion == null) {
            this.minSdkVersion = 24;
        }
        ArrayList<InputSource> results = new ArrayList<InputSource>();
        List<File> classesDirList = this.listClassesDirectories(smaliDir);
        int i = 0;
        int size = classesDirList.size();
        for (File classesDir : classesDirList) {
            String progress = "(" + StringsUtil.formatNumber(++i, size) + "/" + size + ") ";
            InputSource inputSource = this.build(progress, classesDir);
            results.add(inputSource);
        }
        return results;
    }

    private InputSource build(String progress, File classesDir) throws IOException {
        File dexCacheFile = this.toDexCache(classesDir);
        if (this.isModified(classesDir, dexCacheFile)) {
            return this.build(progress, classesDir, dexCacheFile);
        }
        this.logMessage(progress + "Cached: " + dexCacheFile.getName());
        return new FileInputSource(dexCacheFile, dexCacheFile.getName());
    }

    private InputSource build(String progress, File classesDir, File dexCacheFile) throws IOException {
        if ("internal".equals(this.buildOptions.dexLib)) {
            return this.buildWithInternalLib(progress, classesDir, dexCacheFile);
        }
        return this.buildWithJesusFreke(progress, classesDir, dexCacheFile);
    }

    private InputSource buildWithJesusFreke(String progress, File classesDir, File dexCacheFile) throws IOException {
        boolean success;
        this.logMessage(progress + "Smali<JF>: " + dexCacheFile.getName());
        SmaliOptions smaliOptions = new SmaliOptions();
        FileUtil.ensureParentDirectory(dexCacheFile);
        smaliOptions.outputDexFile = dexCacheFile.getAbsolutePath();
        File marker = new File(classesDir, "markers.txt");
        if (marker.isFile()) {
            smaliOptions.markersListFile = marker.getAbsolutePath();
        }
        if (smaliOptions.jobs <= 0) {
            smaliOptions.jobs = 1;
        }
        if (this.minSdkVersion != null) {
            smaliOptions.apiLevel = this.minSdkVersion;
        }
        if (!(success = Smali.assemble(smaliOptions, classesDir.getAbsolutePath()))) {
            throw new IOException("Failed to build smali, check the logs");
        }
        return new FileInputSource(dexCacheFile, dexCacheFile.getName());
    }

    private InputSource buildWithInternalLib(String progress, File classesDir, File dexCacheFile) throws IOException {
        this.logMessage(progress + "Smali<INTERNAL>: " + dexCacheFile.getName());
        DexFile dexFile = DexFile.createDefault();
        int version = 0;
        if (this.minSdkVersion != null) {
            version = this.minSdkVersion;
        }
        version = SmaliCompiler.apiToDexVersion(version);
        dexFile.setVersion(version);
        dexFile.parseSmaliDirectory(classesDir);
        dexFile.refreshFull();
        dexFile.write(dexCacheFile);
        dexFile.close();
        return new FileInputSource(dexCacheFile, dexCacheFile.getName());
    }

    private boolean isModified(File classesDir, File dexCacheFile) {
        if (this.buildOptions.noCache || !dexCacheFile.isFile()) {
            return true;
        }
        long dexMod = dexCacheFile.lastModified();
        return this.isModified(classesDir, dexMod);
    }

    private boolean isModified(File dir, long dexMod) {
        if (dir.lastModified() > dexMod) {
            return true;
        }
        if (!dir.isDirectory()) {
            return false;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return false;
        }
        for (File file : files) {
            if (!this.isModified(file, dexMod)) continue;
            return true;
        }
        return false;
    }

    private File toDexCache(File classesDir) {
        File mainDir = classesDir.getParentFile().getParentFile();
        File dir = new File(mainDir, ".cache");
        return new File(dir, SmaliUtil.getDexFileName(SmaliUtil.getDexNumber(classesDir.getName())));
    }

    private List<File> listClassesDirectories(File smaliDir) {
        ArrayList<File> results = new ArrayList<File>();
        if (!smaliDir.isDirectory()) {
            return results;
        }
        File[] files = smaliDir.listFiles();
        if (files == null) {
            return results;
        }
        for (File file : files) {
            if (!SmaliUtil.isClassesDir(file)) {
                this.logMessage("WARN: Ignore: " + file);
                continue;
            }
            results.add(file);
        }
        SmaliUtil.sortDexFiles(results);
        return results;
    }

    public void setApkLogger(APKLogger apkLogger) {
        this.apkLogger = apkLogger;
    }

    private void logMessage(String msg) {
        APKLogger apkLogger = this.apkLogger;
        if (apkLogger != null) {
            apkLogger.logMessage(msg);
        }
    }

    public static int apiToDexVersion(int api) {
        if (api <= 23) {
            return 35;
        }
        switch (api) {
            case 24: 
            case 25: {
                return 37;
            }
            case 26: 
            case 27: {
                return 38;
            }
            case 28: {
                return 39;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                return 40;
            }
            case 35: {
                return 41;
            }
        }
        return 39;
    }
}

