/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.refactor;

import com.reandroid.apk.APKLogger;
import com.reandroid.apk.ApkModule;
import com.reandroid.apk.ResFile;
import com.reandroid.apkeditor.refactor.EntryRefactor;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.identifiers.PackageIdentifier;
import com.reandroid.identifiers.TableIdentifier;
import com.reandroid.identifiers.TypeIdentifier;
import java.io.IOException;
import java.util.List;

public class AutoRefactor {
    private final ApkModule mApkModule;
    private APKLogger apkLogger;

    public AutoRefactor(ApkModule apkModule) {
        this.mApkModule = apkModule;
        this.apkLogger = apkModule.getApkLogger();
    }

    public void refactor() throws IOException {
        this.refactorResourceNames();
        this.refactorFilePaths();
    }

    public int refactorFilePaths() {
        this.logMessage("Validating file paths ...");
        int renameCount = 0;
        List<ResFile> resFileList = this.mApkModule.listResFiles();
        for (ResFile resFile : resFileList) {
            String path = "res/" + resFile.buildPath();
            if (path.equals(resFile.getFilePath())) continue;
            resFile.setFilePath(path);
            ++renameCount;
        }
        return renameCount;
    }

    private void refactorResourceNames() {
        this.logMessage("Validating resource names ...");
        TableIdentifier tableIdentifier = new TableIdentifier();
        TableBlock tableBlock = this.mApkModule.getTableBlock();
        tableIdentifier.load(tableBlock);
        String msg = tableIdentifier.validateSpecNames();
        if (msg == null) {
            this.logMessage("All resource names are valid");
            return;
        }
        int count = 0;
        for (PackageIdentifier pi : tableIdentifier.getPackages()) {
            for (TypeIdentifier ti : pi.list()) {
                EntryRefactor entryRefactor = new EntryRefactor(ti);
                count += entryRefactor.refactorAll();
            }
        }
        this.logMessage(msg);
    }

    public void setApkLogger(APKLogger apkLogger) {
        this.apkLogger = apkLogger;
    }

    void logMessage(String msg) {
        APKLogger apkLogger = this.apkLogger;
        if (apkLogger != null) {
            apkLogger.logMessage(msg);
        }
    }

    void logError(String msg, Throwable tr) {
        APKLogger apkLogger = this.apkLogger;
        if (apkLogger == null || msg == null && tr == null) {
            return;
        }
        apkLogger.logError(msg, tr);
    }

    void logVerbose(String msg) {
        APKLogger apkLogger = this.apkLogger;
        if (apkLogger != null) {
            apkLogger.logVerbose(msg);
        }
    }
}

