/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.protect;

import com.reandroid.apk.ApkModule;
import com.reandroid.apk.DexFileInputSource;
import com.reandroid.app.AndroidManifest;
import com.reandroid.archive.block.CentralEntryHeader;
import com.reandroid.archive.block.DataDescriptor;
import com.reandroid.archive.block.LocalFileHeader;
import com.reandroid.archive.writer.ApkFileWriter;
import com.reandroid.archive.writer.HeaderInterceptor;
import com.reandroid.arsc.chunk.TableBlock;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class ProtectedFileWriter
implements HeaderInterceptor {
    private final ApkModule apkModule;
    private final File file;
    private final Set<String> mProtectedFiles;

    public ProtectedFileWriter(ApkModule apkModule, File file) {
        this.apkModule = apkModule;
        this.file = file;
        this.mProtectedFiles = new HashSet<String>();
    }

    public void write() throws IOException {
        ApkFileWriter writer = this.apkModule.createApkFileWriter(this.file);
        writer.getInterceptorChain().setHeaderInterceptor(this);
        writer.write();
        writer.close();
    }

    @Override
    public void onWriteLfh(LocalFileHeader lfh) {
        String name = lfh.getFileName();
        if (this.needsProtection(name)) {
            this.mProtectedFiles.add(name);
            lfh.getGeneralPurposeFlag().setEncryption(true);
        }
    }

    @Override
    public void onWriteDD(DataDescriptor dataDescriptor) {
    }

    @Override
    public void onWriteCeh(CentralEntryHeader ceh) {
        if (this.mProtectedFiles.contains(ceh.getFileName())) {
            ceh.getGeneralPurposeFlag().setEncryption(true);
        }
    }

    private boolean needsProtection(String name) {
        if (AndroidManifest.FILE_NAME.equals(name)) {
            return true;
        }
        if (TableBlock.FILE_NAME.equals(name)) {
            return true;
        }
        if (name.startsWith("lib/") && name.endsWith(".so")) {
            return true;
        }
        return DexFileInputSource.isDexName(name);
    }
}

