/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.protect;

import com.reandroid.apkeditor.protect.Confuser;
import com.reandroid.apkeditor.protect.Protector;
import com.reandroid.arsc.chunk.ChunkType;
import com.reandroid.arsc.chunk.xml.AndroidManifestBlock;
import com.reandroid.arsc.chunk.xml.ResXmlAttribute;
import com.reandroid.arsc.chunk.xml.ResXmlDocument;
import com.reandroid.arsc.chunk.xml.ResXmlElement;
import com.reandroid.arsc.chunk.xml.ResXmlElementApi;
import com.reandroid.arsc.chunk.xml.UnknownResXmlNode;
import com.reandroid.arsc.header.StringPoolHeader;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.ByteArray;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.arsc.item.ResXmlString;
import com.reandroid.arsc.pool.ResXmlStringPool;
import com.reandroid.utils.NumbersUtil;
import com.reandroid.utils.collection.CollectionUtil;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public class ManifestConfuser
extends Confuser {
    public ManifestConfuser(Protector protector) {
        super(protector, "ManifestConfuser: ");
    }

    @Override
    public void confuse() {
        if (this.getOptions().skipManifest) {
            this.logMessage("Skip");
            return;
        }
        AndroidManifestBlock manifestBlock = this.getApkModule().getAndroidManifest();
        this.placeBadChunk(manifestBlock);
        this.confuseAttributes(manifestBlock);
        this.confuseOffset(manifestBlock);
        manifestBlock.refresh();
    }

    private void confuseAttributes(AndroidManifestBlock manifestBlock) {
        int defaultAttributeSize = 20;
        List<ResXmlElement> elementList = CollectionUtil.toList(manifestBlock.recursiveElements());
        Random random = new Random();
        for (ResXmlElement element : elementList) {
            int size = defaultAttributeSize + random.nextInt(6) + 1;
            element.setAttributesUnitSize(size, false);
            ResXmlAttribute attribute = element.newAttribute();
            attribute.setName(" >\n  </" + element.getName() + ">\n  android:name", 0);
            attribute.setValueAsBoolean(false);
        }
        manifestBlock.getManifestElement().setAttributesUnitSize(defaultAttributeSize, false);
    }

    private void confuseOffset(AndroidManifestBlock manifestBlock) {
        ResXmlElement manifest = manifestBlock.getManifestElement();
        Iterator iterator = manifest.getElements();
        while (iterator.hasNext()) {
            this.confuseOffset((ResXmlElement)iterator.next());
        }
        this.confuseOffset(manifest);
    }

    private void confuseOffset(ResXmlElement element) {
        ResXmlElementApi elementApi = new ResXmlElementApi(element);
        int size = elementApi.getAttributeArray().countBytes() + 1;
        ByteArray byteArray = new ByteArray();
        byteArray.setSize(size);
        for (int i = 0; i < size; i += 4) {
            byteArray.putInteger(i, -1);
        }
        elementApi.getStartElement().getFirstPlaceHolder().setItem(byteArray);
        element.refresh();
    }

    private void placeBadChunk(AndroidManifestBlock manifestBlock) {
        this.placeBadChunk(manifestBlock, ChunkType.XML_END_NAMESPACE);
        this.placeBadChunk(manifestBlock, ChunkType.PACKAGE);
    }

    private void placeBadChunk(AndroidManifestBlock manifestBlock, ChunkType chunkType) {
        UnknownResXmlNode unknown = manifestBlock.newUnknown();
        try {
            unknown.readBytes(new BlockReader(this.randomStringPool(chunkType)));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        manifestBlock.moveTo(unknown, 0);
    }

    private byte[] randomStringPool(ChunkType chunkType) {
        ResXmlDocument document = new ResXmlDocument();
        ResXmlStringPool stringPool = document.getStringPool();
        Random random = new Random();
        int size = NumbersUtil.min(20, 5 + random.nextInt(21));
        stringPool.setUtf8(size % 2 == 0);
        for (int i = 0; i < size; ++i) {
            String s = this.randomString();
            ResXmlString xml = stringPool.getOrCreate(s);
            xml.addReference(new IntegerItem());
        }
        stringPool.refresh();
        stringPool.refresh();
        ((StringPoolHeader)stringPool.getHeaderBlock()).setType(chunkType);
        return stringPool.getBytes();
    }

    private String randomString() {
        StringBuilder builder = new StringBuilder();
        Random random = new Random();
        int size = NumbersUtil.min(100, 15 + random.nextInt(90));
        for (int i = 0; i < size; ++i) {
            char c = (char)(10 + random.nextInt(240));
            builder.append(c);
        }
        return builder.toString();
    }
}

