/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.merge;

import com.reandroid.apk.ApkBundle;
import com.reandroid.apk.ApkModule;
import com.reandroid.apkeditor.CommandExecutor;
import com.reandroid.apkeditor.Util;
import com.reandroid.apkeditor.common.AndroidManifestHelper;
import com.reandroid.apkeditor.merge.MergerOptions;
import com.reandroid.app.AndroidManifest;
import com.reandroid.archive.ArchiveEntry;
import com.reandroid.archive.ArchiveFile;
import com.reandroid.archive.ZipEntryMap;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.chunk.xml.AndroidManifestBlock;
import com.reandroid.arsc.chunk.xml.ResXmlAttribute;
import com.reandroid.arsc.chunk.xml.ResXmlElement;
import com.reandroid.arsc.container.SpecTypePair;
import com.reandroid.arsc.model.ResourceEntry;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResValue;
import com.reandroid.arsc.value.ValueType;
import com.reandroid.utils.HexUtil;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;

public class Merger
extends CommandExecutor<MergerOptions> {
    public Merger(MergerOptions options) {
        super(options, "[MERGE] ");
    }

    @Override
    public void runCommand() throws IOException {
        MergerOptions options = (MergerOptions)this.getOptions();
        this.delete(options.outputFile);
        File dir = options.inputFile;
        boolean extracted = false;
        if (dir.isFile()) {
            dir = this.extractFile(dir);
            extracted = true;
        }
        this.logMessage("Searching apk files ...");
        ApkBundle bundle = new ApkBundle();
        bundle.setAPKLogger(this);
        bundle.loadApkDirectory(dir, extracted);
        this.logMessage("Found modules: " + bundle.getApkModuleList().size());
        for (ApkModule apkModule : bundle.getApkModuleList()) {
            String protect = Util.isProtected(apkModule);
            if (protect == null) continue;
            this.logMessage(options.inputFile.getAbsolutePath());
            this.logMessage(protect);
            return;
        }
        ApkModule mergedModule = bundle.mergeModules(options.validateModules);
        if (options.resDirName != null) {
            this.logMessage("Renaming resources root dir: " + options.resDirName);
            mergedModule.setResourcesRootDir(options.resDirName);
        }
        if (options.validateResDir) {
            this.logMessage("Validating resources dir ...");
            mergedModule.validateResourcesDir();
        }
        if (options.cleanMeta) {
            this.logMessage("Clearing META-INF ...");
            Merger.clearMeta(mergedModule);
        }
        this.sanitizeManifest(mergedModule);
        mergedModule.refreshTable();
        mergedModule.refreshManifest();
        this.applyExtractNativeLibs(mergedModule, options.getExtractNativeLibs());
        this.logMessage("Writing apk ...");
        mergedModule.writeApk(options.outputFile);
        mergedModule.close();
        bundle.close();
        if (extracted) {
            Util.deleteDir(dir);
            dir.deleteOnExit();
        }
        this.logMessage("Saved to: " + options.outputFile);
    }

    private File extractFile(File file) throws IOException {
        File tmp = this.toTmpDir(file);
        this.logMessage("Extracting to: " + tmp);
        if (tmp.exists()) {
            this.logMessage("Delete: " + tmp);
            Util.deleteDir(tmp);
        }
        tmp.deleteOnExit();
        ArchiveFile archive = new ArchiveFile(file);
        this.fixFilePermissions(archive);
        Predicate<ArchiveEntry> filter = archiveEntry -> archiveEntry.getName().endsWith(".apk");
        int count = archive.extractAll(tmp, filter, this);
        archive.close();
        if (count == 0) {
            throw new IOException("No *.apk files found on: " + file);
        }
        return tmp;
    }

    private void fixFilePermissions(ArchiveFile archive) {
        int rw_all = 438;
        Iterator<ArchiveEntry> iterator = archive.iterator();
        while (iterator.hasNext()) {
            ArchiveEntry entry = iterator.next();
            entry.getCentralEntryHeader().getFilePermissions().permissions(rw_all);
        }
    }

    private File toTmpDir(File file) {
        String name = file.getName();
        name = HexUtil.toHex8("tmp_", name.hashCode());
        File dir = file.getParentFile();
        File tmp = dir == null ? new File(name) : new File(dir, name);
        tmp = Util.ensureUniqueFile(tmp);
        return tmp;
    }

    private void sanitizeManifest(ApkModule apkModule) {
        if (!apkModule.hasAndroidManifest()) {
            return;
        }
        AndroidManifestBlock manifest = apkModule.getAndroidManifest();
        this.logMessage("Sanitizing manifest ...");
        AndroidManifestHelper.removeAttributeFromManifestById(manifest, AndroidManifest.ID_requiredSplitTypes, this);
        AndroidManifestHelper.removeAttributeFromManifestById(manifest, AndroidManifest.ID_splitTypes, this);
        AndroidManifestHelper.removeAttributeFromManifestByName(manifest, AndroidManifest.NAME_splitTypes, this);
        AndroidManifestHelper.removeAttributeFromManifestByName(manifest, AndroidManifest.NAME_requiredSplitTypes, this);
        AndroidManifestHelper.removeAttributeFromManifestByName(manifest, AndroidManifest.NAME_splitTypes, this);
        AndroidManifestHelper.removeAttributeFromManifestAndApplication(manifest, AndroidManifest.ID_isSplitRequired, this, AndroidManifest.NAME_isSplitRequired);
        ResXmlElement application = manifest.getApplicationElement();
        List<ResXmlElement> splitMetaDataElements = AndroidManifestHelper.listSplitRequired(application);
        boolean splits_removed = false;
        for (ResXmlElement meta : splitMetaDataElements) {
            if (!splits_removed) {
                splits_removed = this.removeSplitsTableEntry(meta, apkModule);
            }
            this.logMessage("Removed-element : <" + meta.getName() + "> name=\"" + AndroidManifestBlock.getAndroidNameValue(meta) + "\"");
            application.remove(meta);
        }
        manifest.refresh();
    }

    private boolean removeSplitsTableEntry(ResXmlElement metaElement, ApkModule apkModule) {
        ResXmlAttribute nameAttribute = metaElement.searchAttributeByResourceId(AndroidManifest.ID_name);
        if (nameAttribute == null) {
            return false;
        }
        if (!"com.android.vending.splits".equals(nameAttribute.getValueAsString())) {
            return false;
        }
        ResXmlAttribute valueAttribute = metaElement.searchAttributeByResourceId(AndroidManifest.ID_value);
        if (valueAttribute == null) {
            valueAttribute = metaElement.searchAttributeByResourceId(AndroidManifest.ID_resource);
        }
        if (valueAttribute == null || valueAttribute.getValueType() != ValueType.REFERENCE) {
            return false;
        }
        if (!apkModule.hasTableBlock()) {
            return false;
        }
        TableBlock tableBlock = apkModule.getTableBlock();
        ResourceEntry resourceEntry = tableBlock.getResource(valueAttribute.getData());
        if (resourceEntry == null) {
            return false;
        }
        ZipEntryMap zipEntryMap = apkModule.getZipEntryMap();
        for (Entry entry : resourceEntry) {
            ResValue resValue;
            if (entry == null || (resValue = entry.getResValue()) == null) continue;
            String path = resValue.getValueAsString();
            this.logMessage("Removed-table-entry : " + path);
            zipEntryMap.remove(path);
            entry.setNull(true);
            SpecTypePair specTypePair = entry.getTypeBlock().getParentSpecTypePair();
            specTypePair.removeNullEntries(entry.getId());
        }
        return true;
    }
}

