/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.compile;

import com.reandroid.apkeditor.OptionsWithFramework;
import com.reandroid.apkeditor.compile.Builder;
import com.reandroid.app.AndroidManifest;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.jcommand.annotations.ChoiceArg;
import com.reandroid.jcommand.annotations.CommandOptions;
import com.reandroid.jcommand.annotations.OptionArg;
import com.reandroid.jcommand.exceptions.CommandException;
import java.io.File;

@CommandOptions(name="b", alternates={"build"}, description="build_description", examples={"build_example_1", "build_example_2", "build_example_3", "build_example_4"})
public class BuildOptions
extends OptionsWithFramework {
    @ChoiceArg(name="-t", values={"xml", "json", "raw", "sig"}, description="build_types")
    public String type;
    @ChoiceArg(name="-extractNativeLibs", values={"manifest", "none", "false", "true"}, description="extract_native_libs")
    public String extractNativeLibs;
    @OptionArg(name="-vrd", description="validate_resources_dir", flag=true)
    public boolean validateResDir;
    @OptionArg(name="-res-dir", description="res_dir_name")
    public String resDirName;
    @OptionArg(name="-no-cache", description="build_no_cache", flag=true)
    public boolean noCache;
    @ChoiceArg(name="-dex-lib", values={"internal", "jf"}, description="dex_lib")
    public String dexLib = "jf";
    @OptionArg(name="-sig", description="signatures_path")
    public File signaturesDirectory;

    public Builder newCommandExecutor() {
        return new Builder(this);
    }

    @Override
    public void validateInput(boolean isFile, boolean isDirectory) {
        super.validateInput(isFile, !(isFile = "sig".equals(this.type)));
        this.evaluateInputDirectoryType();
        this.validateSignaturesDirectory();
    }

    private void evaluateInputDirectoryType() {
        String type = this.type;
        if (type != null) {
            return;
        }
        File file = this.inputFile;
        if (BuildOptions.isRawInputDirectory(file)) {
            type = "raw";
        } else if (BuildOptions.isJsonInputDirectory(file)) {
            type = "json";
            this.inputFile = BuildOptions.getJsonInDir(this.inputFile);
        } else if (BuildOptions.isXmlInputDirectory(file)) {
            type = "xml";
        } else if (this.signaturesDirectory != null) {
            type = "sig";
        } else {
            throw new CommandException("unknown_build_directory", file);
        }
        this.type = type;
    }

    @Override
    public void validateOutput(boolean isFile) {
        super.validateOutput(true);
    }

    private void validateSignaturesDirectory() {
        if ("sig".equals(this.type)) {
            File file = this.signaturesDirectory;
            if (file == null) {
                throw new CommandException("missing_sig_directory", new Object[0]);
            }
            this.validateInputFile(file, false, true);
        } else if (this.signaturesDirectory != null) {
            throw new CommandException("invalid_sig_parameter_combination", new Object[0]);
        }
    }

    @Override
    public File generateOutputFromInput(File file) {
        return this.generateOutputFromInput(file, "_out.apk");
    }

    public String getExtractNativeLibs() {
        String extractNativeLibs = this.extractNativeLibs;
        if (extractNativeLibs == null) {
            extractNativeLibs = "manifest";
        }
        return extractNativeLibs;
    }

    private static boolean isRawInputDirectory(File dir) {
        File file = new File(dir, AndroidManifest.FILE_NAME_BIN);
        if (!file.isFile()) {
            file = new File(dir, TableBlock.FILE_NAME);
        }
        return file.isFile();
    }

    private static boolean isXmlInputDirectory(File dir) {
        File manifest = new File(dir, AndroidManifest.FILE_NAME);
        return manifest.isFile();
    }

    private static boolean isJsonInputDirectory(File dir) {
        if (BuildOptions.isModuleDir(dir)) {
            return true;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return false;
        }
        for (File file : files) {
            if (!BuildOptions.isModuleDir(file)) continue;
            return true;
        }
        return false;
    }

    private static boolean isModuleDir(File dir) {
        if (!dir.isDirectory()) {
            return false;
        }
        File file = new File(dir, AndroidManifest.FILE_NAME_JSON);
        return file.isFile();
    }

    private static File getJsonInDir(File dir) {
        if (BuildOptions.isModuleDir(dir)) {
            return dir;
        }
        File[] files = dir.listFiles();
        if (files == null || files.length == 0) {
            throw new CommandException("Empty directory: %s", dir);
        }
        for (File file : files) {
            if (!BuildOptions.isModuleDir(file)) continue;
            return file;
        }
        throw new CommandException("Invalid directory: '%s', missing file \"uncompressed-files.json\"", dir);
    }
}

