/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor;

import com.reandroid.apk.ApkModule;
import com.reandroid.archive.InputSource;
import com.reandroid.archive.ZipEntryMap;
import java.io.File;
import java.util.Iterator;

public class Util {
    public static final String EDIT_TYPE_PROTECTED = "PROTECTED";

    public static File ensureUniqueFile(File file) {
        int i;
        if (!file.exists()) {
            return file;
        }
        File dir = file.getParentFile();
        String name = file.getName();
        String ext = "";
        if (file.isFile() && (i = name.lastIndexOf(46)) > 0) {
            ext = name.substring(i);
            name = name.substring(0, i);
        }
        for (i = 1; i < 1000 && file.exists(); ++i) {
            String newName = name + "_" + i + ext;
            file = dir == null ? new File(newName) : new File(dir, newName);
        }
        return file;
    }

    public static void deleteDir(File dir) {
        if (!dir.exists()) {
            return;
        }
        if (dir.isFile()) {
            dir.delete();
            return;
        }
        if (!dir.isDirectory()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            Util.deleteEmptyDirectories(dir);
            return;
        }
        for (File file : files) {
            Util.deleteDir(file);
        }
        Util.deleteEmptyDirectories(dir);
    }

    public static void deleteEmptyDirectories(File dir) {
        if (dir == null || !dir.isDirectory()) {
            return;
        }
        File[] filesList = dir.listFiles();
        if (filesList == null || filesList.length == 0) {
            dir.delete();
            return;
        }
        for (File file : filesList) {
            if (!file.isFile() || file.length() == 0L) continue;
            return;
        }
        for (File file : filesList) {
            if (!file.isDirectory()) continue;
            Util.deleteEmptyDirectories(file);
        }
        filesList = dir.listFiles();
        if (filesList == null || filesList.length == 0) {
            dir.delete();
        }
    }

    public static String isProtected(ApkModule apkModule) {
        ZipEntryMap zipEntryMap = apkModule.getZipEntryMap();
        Iterator<InputSource> iterator = zipEntryMap.iteratorWithPath(path -> path.startsWith("classes.dex/") || path.startsWith("AndroidManifest.xml/"));
        if (iterator.hasNext()) {
            return EDIT_TYPE_PROTECTED;
        }
        return null;
    }
}

