/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk;

import com.reandroid.apk.ApkModule;
import com.reandroid.apk.ResFile;
import com.reandroid.archive.InputSource;
import com.reandroid.archive.PathTree;
import com.reandroid.archive.ZipEntryMap;
import com.reandroid.json.JSONArray;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PathMap
implements JSONConvert<JSONArray> {
    private final Object mLock = new Object();
    private final Map<String, String> mNameAliasMap = new HashMap<String, String>();
    private final Map<String, String> mAliasNameMap = new HashMap<String, String>();
    public static final String NAME_name = "name";
    public static final String NAME_alias = "alias";
    public static final String JSON_FILE = "path-map.json";

    public void restore(ApkModule apkModule) {
        if (apkModule.getLoadedTableBlock() != null) {
            this.restoreResFile(apkModule.listResFiles());
        }
        this.restore(apkModule.getInputSources());
    }

    public void restoreResFile(Collection<ResFile> files) {
        if (files == null) {
            return;
        }
        for (ResFile resFile : files) {
            this.restoreResFile(resFile);
        }
    }

    public void restoreResFile(ResFile resFile) {
        InputSource inputSource = resFile.getInputSource();
        String alias = this.restore(inputSource);
        if (alias == null) {
            return;
        }
        resFile.setFilePath(alias);
    }

    private void restore(InputSource[] sources) {
        for (InputSource inputSource : sources) {
            this.restore(inputSource);
        }
    }

    public String restore(InputSource inputSource) {
        if (inputSource == null) {
            return null;
        }
        String name = inputSource.getName();
        String alias = this.getName(name);
        if (alias == null) {
            name = inputSource.getAlias();
            alias = this.getName(name);
        }
        if (alias == null || alias.equals(inputSource.getAlias())) {
            return null;
        }
        inputSource.setAlias(alias);
        return alias;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAlias(String name) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mNameAliasMap.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName(String alias) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mAliasNameMap.get(alias);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mNameAliasMap.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.mLock;
        synchronized (object) {
            this.mNameAliasMap.clear();
            this.mAliasNameMap.clear();
        }
    }

    public void add(ZipEntryMap zipEntryMap) {
        if (zipEntryMap == null) {
            return;
        }
        this.add(zipEntryMap.toArray());
    }

    public void add(InputSource[] sources) {
        if (sources == null) {
            return;
        }
        for (InputSource inputSource : sources) {
            this.add(inputSource);
        }
    }

    public void add(InputSource inputSource) {
        if (inputSource == null) {
            return;
        }
        this.add(inputSource.getName(), inputSource.getAlias());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String name, String alias) {
        if (name == null || alias == null) {
            return;
        }
        if (name.equals(alias)) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mNameAliasMap.remove(name);
            this.mNameAliasMap.put(name, alias);
            this.mAliasNameMap.remove(alias);
            this.mAliasNameMap.put(alias, name);
        }
    }

    private void add(JSONObject json) {
        if (json == null) {
            return;
        }
        this.add(json.optString(NAME_name), json.optString(NAME_alias));
    }

    @Override
    public JSONArray toJson() {
        JSONArray jsonArray = new JSONArray();
        Map<String, String> nameMap = this.mNameAliasMap;
        Iterator<String> nameList = PathTree.sortPaths(nameMap.keySet().iterator());
        while (nameList.hasNext()) {
            String name = nameList.next();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put(NAME_name, name);
            jsonObject.put(NAME_alias, nameMap.get(name));
            jsonArray.put(jsonObject);
        }
        return jsonArray;
    }

    @Override
    public void fromJson(JSONArray json) {
        this.clear();
        if (json == null) {
            return;
        }
        int length = json.length();
        for (int i = 0; i < length; ++i) {
            this.add(json.optJSONObject(i));
        }
    }

    public String toString() {
        return "PathMap size=" + this.size();
    }
}

