/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk;

import com.reandroid.apk.ApkModule;
import com.reandroid.apk.ApkModuleEncoder;
import com.reandroid.archive.FileInputSource;
import com.reandroid.archive.ZipEntryMap;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.chunk.xml.AndroidManifestBlock;
import java.io.File;

public class ApkModuleRawEncoder
extends ApkModuleEncoder {
    private final ApkModule apkModule;
    private boolean mKeepOriginal;

    public ApkModuleRawEncoder() {
        ZipEntryMap zipEntryMap = new ZipEntryMap();
        String name = "encoded_raw" + String.valueOf(zipEntryMap.hashCode()).substring(1);
        this.apkModule = new ApkModule(name, zipEntryMap);
    }

    public void setKeepOriginal(boolean keepOriginal) {
        this.mKeepOriginal = keepOriginal;
    }

    public boolean isKeepOriginal() {
        return this.mKeepOriginal;
    }

    @Override
    public void buildResources(File mainDirectory) {
        this.addTableBlock(mainDirectory);
    }

    @Override
    public ApkModule getApkModule() {
        return this.apkModule;
    }

    @Override
    public void encodeBinaryManifest(File mainDirectory) {
        File file = new File(mainDirectory, AndroidManifestBlock.FILE_NAME_BIN);
        if (!(file.isFile() || (file = new File(mainDirectory, AndroidManifestBlock.FILE_NAME)).isFile() && AndroidManifestBlock.isResXmlBlock(file))) {
            this.logMessage("WARN: Missing file " + AndroidManifestBlock.FILE_NAME_BIN);
            return;
        }
        this.logMessage("Loaded binary manifest: " + file.getName());
        FileInputSource inputSource = new FileInputSource(file, AndroidManifestBlock.FILE_NAME);
        ApkModule apkModule = this.getApkModule();
        apkModule.add(inputSource);
        if (this.isKeepOriginal()) {
            apkModule.discardManifestChanges();
        }
    }

    private void addTableBlock(File mainDirectory) {
        File file = new File(mainDirectory, TableBlock.FILE_NAME);
        if (!file.isFile()) {
            this.logMessage("Warn: File not found: " + TableBlock.FILE_NAME);
            return;
        }
        this.getApkModule().setLoadDefaultFramework(false);
        FileInputSource inputSource = new FileInputSource(file, TableBlock.FILE_NAME);
        ApkModule apkModule = this.getApkModule();
        apkModule.add(inputSource);
        if (this.isKeepOriginal()) {
            apkModule.discardManifestChanges();
        }
    }

    @Override
    void refreshTable() {
        if (!this.isKeepOriginal() && this.getApkModule().getLoadedTableBlock() != null) {
            super.refreshTable();
        }
    }

    @Override
    void onScanDirectoryComplete() {
        if (this.isKeepOriginal()) {
            ApkModule apkModule = this.getApkModule();
            apkModule.discardTableBlockChanges();
            apkModule.discardManifestChanges();
        }
    }
}

