/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk;

import com.reandroid.apk.ApkModule;
import com.reandroid.apk.ApkModuleCoder;
import com.reandroid.apk.DecodeFilter;
import com.reandroid.apk.DexDecoder;
import com.reandroid.apk.DexFileInputSource;
import com.reandroid.apk.DexFileRawDecoder;
import com.reandroid.apk.PathMap;
import com.reandroid.apk.PathSanitizer;
import com.reandroid.apk.UncompressedFiles;
import com.reandroid.archive.ArchiveInfo;
import com.reandroid.archive.InputSource;
import com.reandroid.archive.ZipEntryMap;
import com.reandroid.archive.block.ApkSignatureBlock;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.dex.model.DexDirectory;
import com.reandroid.dex.sections.Marker;
import com.reandroid.identifiers.PackageIdentifier;
import com.reandroid.identifiers.TableIdentifier;
import com.reandroid.json.JSONArray;
import com.reandroid.json.JSONObject;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class ApkModuleDecoder
extends ApkModuleCoder {
    private final ApkModule apkModule;
    private final Set<String> mDecodedPaths;
    private DexDecoder mDexDecoder;
    private boolean mLogErrors;
    private DecodeFilter mDecodeFilter;

    public ApkModuleDecoder(ApkModule apkModule) {
        this.apkModule = apkModule;
        this.mDecodedPaths = new HashSet<String>();
        this.setApkLogger(apkModule.getApkLogger());
    }

    public final void decode(File mainDirectory) throws IOException {
        this.initialize();
        this.decodeArchiveInfo(mainDirectory);
        this.decodeUncompressedFiles(mainDirectory);
        this.decodeAndroidManifest(mainDirectory);
        this.decodeResourceTable(mainDirectory);
        this.decodeDexFiles(mainDirectory);
        this.extractRootFiles(mainDirectory);
        this.decodePathMap(mainDirectory);
        this.dumpSignatures(mainDirectory);
    }

    public abstract void decodeResourceTable(File var1) throws IOException;

    abstract void decodeAndroidManifest(File var1) throws IOException;

    public void extractRootFiles(File mainDirectory) throws IOException {
        this.logMessage("Extracting root files ...");
        File rootDir = new File(mainDirectory, "root");
        for (InputSource inputSource : this.apkModule.getInputSources()) {
            if (this.containsDecodedPath(inputSource.getAlias())) continue;
            this.extractRootFile(rootDir, inputSource);
            this.addDecodedPath(inputSource.getAlias());
        }
    }

    public void decodeDexInfo(File mainDirectory) throws IOException {
        File file = new File(mainDirectory, "dex-info.json");
        this.logMessage("Decode: " + file.getName());
        ZipEntryMap zipEntryMap = this.apkModule.getZipEntryMap();
        DexDirectory dexDirectory = DexDirectory.readStrings(zipEntryMap);
        JSONObject jsonObject = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        Iterator<Marker> markers = dexDirectory.getMarkers();
        while (markers.hasNext()) {
            jsonArray.put(markers.next().getJsonObject());
        }
        jsonObject.put("markers", jsonArray);
        jsonObject.write(file);
    }

    public void decodeArchiveInfo(File mainDirectory) throws IOException {
        File file = new File(mainDirectory, ArchiveInfo.JSON_FILE);
        this.logMessage("Decode: " + file.getName());
        ZipEntryMap zipEntryMap = this.apkModule.getZipEntryMap();
        ArchiveInfo archiveInfo = zipEntryMap.getOrCreateArchiveInfo();
        archiveInfo.writeToDirectory(mainDirectory);
    }

    public void decodeUncompressedFiles(File mainDirectory) throws IOException {
        File file = new File(mainDirectory, "uncompressed-files.json");
        this.logMessage("Decode: " + file.getName());
        UncompressedFiles uncompressedFiles = new UncompressedFiles();
        uncompressedFiles.addCommonExtensions();
        uncompressedFiles.addPath(this.getApkModule().getZipEntryMap());
        uncompressedFiles.toJson().write(file);
    }

    public void decodeDexFiles(File mainDir) throws IOException {
        ApkModule apkModule = this.getApkModule();
        List<DexFileInputSource> dexList = apkModule.listDexFiles();
        DexDecoder dexDecoder = this.getDexDecoder();
        dexDecoder.decodeDex(apkModule, mainDir);
        for (DexFileInputSource inputSource : dexList) {
            this.addDecodedPath(inputSource.getAlias());
        }
    }

    @Override
    public ApkModule getApkModule() {
        return this.apkModule;
    }

    public DexDecoder getDexDecoder() {
        if (this.mDexDecoder == null) {
            DexFileRawDecoder rawDecoder = new DexFileRawDecoder();
            rawDecoder.setApkLogger(this.getApkLogger());
            this.mDexDecoder = rawDecoder;
        }
        return this.mDexDecoder;
    }

    public void setDexDecoder(DexDecoder dexDecoder) {
        this.mDexDecoder = dexDecoder;
    }

    public void sanitizeFilePaths() {
        PathSanitizer sanitizer = PathSanitizer.create(this.getApkModule());
        sanitizer.sanitize();
    }

    public void dumpSignatures(File mainDirectory) throws IOException {
        ApkModule apkModule = this.getApkModule();
        ApkSignatureBlock signatureBlock = apkModule.getApkSignatureBlock();
        if (signatureBlock == null) {
            return;
        }
        File sigDir = new File(mainDirectory, "signatures");
        this.logMessage("Dumping signatures ...");
        signatureBlock.writeSplitRawToDirectory(sigDir);
    }

    public void decodePathMap(File mainDirectory) throws IOException {
        File file = new File(mainDirectory, "path-map.json");
        PathMap pathMap = new PathMap();
        pathMap.add(this.getApkModule().getZipEntryMap());
        pathMap.toJson().write(file);
    }

    public boolean containsDecodedPath(String path) {
        return this.mDecodedPaths.contains(path);
    }

    public void addDecodedPath(String path) {
        this.mDecodedPaths.add(path);
    }

    public DecodeFilter getDecodeFilter() {
        if (this.mDecodeFilter == null) {
            this.mDecodeFilter = new DecodeFilter();
        }
        return this.mDecodeFilter;
    }

    public void setDecodeFilter(DecodeFilter decodeFilter) {
        this.mDecodeFilter = decodeFilter;
    }

    boolean isExcluded(String path) {
        return this.getDecodeFilter().isExcluded(path);
    }

    private void extractRootFile(File rootDir, InputSource inputSource) throws IOException {
        File file = inputSource.toFile(rootDir);
        inputSource.write(file);
    }

    void logOrThrow(String message, Throwable exception) throws IOException {
        if (this.isLogErrors()) {
            this.logError(message, exception);
            return;
        }
        if (message == null && exception == null) {
            return;
        }
        if (exception == null) {
            exception = new IOException(message);
        }
        if (exception instanceof IOException) {
            throw (IOException)exception;
        }
        throw new IOException(exception);
    }

    public void validateResourceNames() {
        this.logMessage("Validating resource names ...");
        TableBlock tableBlock = this.apkModule.getTableBlock();
        TableIdentifier tableIdentifier = new TableIdentifier();
        tableIdentifier.load(tableBlock);
        String msg = tableIdentifier.validateSpecNames();
        if (msg == null) {
            this.logMessage("All resource names are valid");
            return;
        }
        if (tableBlock.removeUnusedSpecs()) {
            msg = msg + ", removed specs";
        }
        this.logMessage(msg);
    }

    public void validateResourceNames(PackageBlock packageBlock) {
        this.logMessage("Validating: " + packageBlock.getName());
        PackageIdentifier packageIdentifier = new PackageIdentifier();
        packageIdentifier.load(packageBlock);
        String msg = packageIdentifier.validateSpecNames();
        if (msg == null) {
            this.logMessage("[" + packageBlock.getName() + "] All resource names are valid");
            return;
        }
        if (packageBlock.removeUnusedSpecs()) {
            msg = "[" + packageBlock.getName() + "]" + msg + ", removed specs";
            this.logMessage(msg);
        }
    }

    void initialize() {
        this.mDecodedPaths.clear();
        this.ensureTableBlock();
    }

    private void ensureTableBlock() {
        ApkModule apkModule = this.getApkModule();
        if (apkModule.ensureTableBlock()) {
            this.logMessage("Missing " + TableBlock.FILE_NAME + ", created empty");
        }
    }

    public boolean isLogErrors() {
        return this.mLogErrors;
    }

    public void setLogErrors(boolean logErrors) {
        this.mLogErrors = logErrors;
    }

    static File toPackageDirectory(File mainDir, PackageBlock packageBlock) {
        File dir = new File(mainDir, TableBlock.DIRECTORY_NAME);
        return new File(dir, packageBlock.buildDecodeDirectoryName());
    }
}

