/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.writer;

import com.android.tools.smali.util.ExceptionWithContext;
import java.io.BufferedOutputStream;
import java.io.OutputStream;

public final class DexDataWriter
extends BufferedOutputStream {
    public int filePosition;
    public byte[] tempBuf = new byte[8];
    public final byte[] zeroBuf = new byte[3];

    public DexDataWriter(OutputStream outputStream, int n, int n2) {
        super(outputStream, n2);
        this.filePosition = n;
    }

    public static void writeInt(OutputStream outputStream, int n) {
        outputStream.write(n);
        outputStream.write(n >> 8);
        outputStream.write(n >> 16);
        outputStream.write(n >> 24);
    }

    public static void writeUleb128(OutputStream outputStream, int n) {
        while (((long)n & 0xFFFFFFFFL) > 127L) {
            outputStream.write(n & 0x7F | 0x80);
            n >>>= 7;
        }
        outputStream.write(n);
    }

    public static void writeSleb128(OutputStream outputStream, int n) {
        if (n >= 0) {
            while (n > 63) {
                outputStream.write(n & 0x7F | 0x80);
                n >>>= 7;
            }
            outputStream.write(n & 0x7F);
        } else {
            while (n < -64) {
                outputStream.write(n & 0x7F | 0x80);
                n >>= 7;
            }
            outputStream.write(n & 0x7F);
        }
    }

    @Override
    public final void write(int n) {
        ++this.filePosition;
        super.write(n);
    }

    @Override
    public final void write(byte[] byArray) {
        int n = 0;
        int n2 = byArray.length;
        this.filePosition += n2;
        super.write(byArray, n, n2);
    }

    @Override
    public final void write(byte[] byArray, int n, int n2) {
        this.filePosition += n2;
        super.write(byArray, n, n2);
    }

    public final void writeShort(int n) {
        if (n >= Short.MIN_VALUE && n <= Short.MAX_VALUE) {
            ((DexDataWriter)((Object)string)).write(n);
            ((DexDataWriter)((Object)string)).write(n >> 8);
            return;
        }
        String string = "Short value out of range: %d";
        Integer n2 = n;
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = n2;
        throw new ExceptionWithContext(null, string, objectArray2);
    }

    public final void writeUshort(int n) {
        if (n >= 0 && n <= 65535) {
            ((DexDataWriter)((Object)string)).write(n);
            ((DexDataWriter)((Object)string)).write(n >> 8);
            return;
        }
        String string = "Unsigned short value out of range: %d";
        Integer n2 = n;
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = n2;
        throw new ExceptionWithContext(null, string, objectArray2);
    }

    public final void writeUbyte(int n) {
        if (n >= 0 && n <= 255) {
            ((DexDataWriter)((Object)string)).write(n);
            return;
        }
        String string = "Unsigned byte value out of range: %d";
        Integer n2 = n;
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = n2;
        throw new ExceptionWithContext(null, string, objectArray2);
    }

    public final void writeEncodedInt(int n, int n2) {
        int n3 = 0;
        if (n2 >= 0) {
            while (n2 > 127) {
                this.tempBuf[n3++] = (byte)n2;
                n2 >>= 8;
            }
        } else {
            while (n2 < -128) {
                this.tempBuf[n3++] = (byte)n2;
                n2 >>= 8;
            }
        }
        DexDataWriter dexDataWriter = this;
        int n4 = n3 + 1;
        this.tempBuf[n3] = (byte)n2;
        dexDataWriter.write(n | n3 << 5);
        byte[] byArray = dexDataWriter.tempBuf;
        n2 = 0;
        dexDataWriter.filePosition += n4;
        super.write(byArray, n2, n4);
    }

    public final void writeEncodedLong(long l) {
        int n = 6;
        int n2 = 0;
        if (l >= 0L) {
            while (l > 127L) {
                this.tempBuf[n2++] = (byte)l;
                l >>= 8;
            }
        } else {
            while (l < -128L) {
                this.tempBuf[n2++] = (byte)l;
                l >>= 8;
            }
        }
        DexDataWriter dexDataWriter = this;
        int n3 = n2 + 1;
        this.tempBuf[n2] = (byte)l;
        dexDataWriter.write(n | n2 << 5);
        byte[] byArray = dexDataWriter.tempBuf;
        int n4 = 0;
        dexDataWriter.filePosition += n3;
        super.write(byArray, n4, n3);
    }

    public final void writeEncodedUint(int n, int n2) {
        int n3 = 0;
        while (true) {
            int n4 = n2;
            int n5 = n2;
            n2 = n3 + 1;
            ((DexDataWriter)object).tempBuf[n3] = (byte)n5;
            int n6 = n4 >>> 8;
            if (n6 == 0) {
                DexDataWriter dexDataWriter = object;
                dexDataWriter.write(n | n3 << 5);
                Object object = dexDataWriter.tempBuf;
                n = 0;
                dexDataWriter.filePosition += n2;
                super.write((byte[])object, n, n2);
                return;
            }
            int n7 = n2;
            n2 = n6;
            n3 = n7;
        }
    }

    public final void writeEncodedFloat(float f) {
        int n = 16;
        int n2 = Float.floatToRawIntBits(f);
        int n3 = 3;
        while (true) {
            int n4 = n2;
            int n5 = n2;
            n2 = n3 + -1;
            this.tempBuf[n3] = (byte)((n5 & 0xFF000000) >>> 24);
            int n6 = n4 << 8;
            if (n6 == 0) {
                DexDataWriter dexDataWriter = this;
                int n7 = 4 - n3;
                dexDataWriter.write(n | 3 - n3 << 5);
                byte[] byArray = dexDataWriter.tempBuf;
                dexDataWriter.filePosition += n7;
                super.write(byArray, n3, n7);
                return;
            }
            int n8 = n2;
            n2 = n6;
            n3 = n8;
        }
    }

    public final void writeEncodedDouble(double d) {
        int n = 17;
        long l = Double.doubleToRawLongBits(d);
        int n2 = 7;
        while (true) {
            int n3 = n2 + -1;
            this.tempBuf[n2] = (byte)((l & 0xFF00000000000000L) >>> 56);
            long l2 = l << 8;
            if (l2 == 0L) {
                DexDataWriter dexDataWriter = this;
                int n4 = 8 - n2;
                dexDataWriter.write(n | 7 - n2 << 5);
                byte[] byArray = dexDataWriter.tempBuf;
                dexDataWriter.filePosition += n4;
                super.write(byArray, n2, n4);
                return;
            }
            l = l2;
            n2 = n3;
        }
    }

    public final void writeString(String string) {
        int n = string.length();
        if (this.tempBuf.length <= string.length() * 3) {
            this.tempBuf = new byte[string.length() * 3];
        }
        byte[] byArray = this.tempBuf;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = string.charAt(i);
            if (n3 != 0 && n3 < 128) {
                int n4 = n3;
                n3 = n2 + 1;
                byArray[n2] = (byte)n4;
                n2 = n3;
                continue;
            }
            if (n3 < 2048) {
                int n5 = n3;
                int n6 = n3;
                n3 = n2 + 1;
                byArray[n2] = (byte)(n6 >> 6 & 0x1F | 0xC0);
                n2 += 2;
                byArray[n3] = (byte)(n5 & 0x3F | 0x80);
                continue;
            }
            int n7 = n3;
            int n8 = n3;
            int n9 = n3;
            n3 = n2 + 1;
            byArray[n2] = (byte)(n9 >> 12 & 0xF | 0xE0);
            int n10 = n2 + 2;
            byArray[n3] = (byte)(n8 >> 6 & 0x3F | 0x80);
            n2 += 3;
            byArray[n10] = (byte)(n7 & 0x3F | 0x80);
        }
        int n11 = 0;
        this.filePosition += n2;
        super.write(byArray, n11, n2);
    }

    public final void align() {
        int n = ((DexDataWriter)object).filePosition;
        int n2 = -n & 3;
        if (n2 > 0) {
            DexDataWriter dexDataWriter = object;
            int n3 = n;
            Object object = ((DexDataWriter)object).zeroBuf;
            n = 0;
            dexDataWriter.filePosition = n3 + n2;
            super.write((byte[])object, n, n2);
        }
    }
}

