@ECHO off
SETLOCAL enableextensions enableDELayedexpansion
SET apk.multitoo.root=C:\AndroidMultiTool\
SET apk.name=

REM forced.meta=0 - Deafult
REM forced.meta=1 - Add META INF separately
SET forced.meta=0

REM log.cmdline=0 - Default - NO decompiling - compiling - signing command line text file creation
REM log.cmdline=1 - Decompiling - compiling - signing command line text file creation
SET log.cmdline=0

SET log.file=AMT.log

:start.menu
CLS
ECHO **********************************************************
ECHO *                   Android Multitool                    *
ECHO **********************************************************
ECHO.
IF     EXIST "%USERPROFILE%\apktool\framework\1.apk"  ECHO     FRAMEWORK = INSTALLED && ECHO.
IF NOT EXIST "%USERPROFILE%\apktool\framework\1.apk"  ECHO     FRAMEWORK = NOT INSTALLED - OPTION 1 && ECHO.
IF %apk.name%*==*                                     ECHO     APK NAME  = NOT DEFINED - OPTION 2
IF NOT %apk.name%*==*                                 ECHO     APK NAME  = %apk.name%.apk
ECHO.
ECHO.
ECHO   1  = INSTALL FRAMEWORK
ECHO.
ECHO   2  = SELECT APK
ECHO.
ECHO   3  = DECOMPILE APK
ECHO.
ECHO   4  = COMPILE APK
ECHO.
ECHO   5  = SIGN APK
ECHO.
ECHO.
ECHO   0  = EXIT
ECHO.
ECHO **********************************************************
ECHO.
SET /P menunr=Select operation: 

IF %menunr%==0 (GOTO end)
IF %menunr%==1 (GOTO install-framework)
IF %menunr%==2 (GOTO filesel)
IF %apk.name%*==* GOTO start.menu
IF %menunr%==3 (GOTO decompile)
IF %menunr%==4 (GOTO compile)
IF %menunr%==5 (GOTO sign)
GOTO start.menu

REM *************************************************************************** Install framework start
:install-framework
CLS
SET framework-res.path=Framework-Files
ECHO ** Framework-res list && ECHO.
ECHO   Framework-res folder = %framework-res.path% && ECHO. && ECHO.
SET /A count=0
FOR %%F IN (%framework-res.path%/*.apk) DO (
SET /A count+=1
SET a!count!=%%~nF
IF /I !count! LEQ 9 (ECHO ^-  !count! - %%F )
IF /I !count! GTR 9 (ECHO ^- !count! - %%F )
)
ECHO. && ECHO.
SET /P INPUT=Choose the framewoerk file - Enter it's number: %=%
IF /I %INPUT% GTR %count% (GOTO start.menu)
IF /I %INPUT% LSS 1 (GOTO start.menu)
SET framework-res.file=!a%INPUT%!.apk
ECHO.
ECHO Framework-res selected = %framework-res.file% && ECHO.

IF NOT EXIST %framework-res.path%\%framework-res.file% GOTO error-install-framework
ECHO Calling framework.res installer with %framework-res.file% && ECHO.
call AMT-framework-install.bat %framework-res.path%\%framework-res.file% && ECHO.
rem start /MIN Program_Files\apktool IF Files\framework-res.apk && ECHO.
@echo off
GOTO end-install-framework

:error-install-framework
ECHO. && ECHO ** File %framework-res.path%\%framework-res.file% not available! && ECHO.

:end-install-framework
ECHO. && ECHO. && ECHO     # Press any ket to continue or CTRL + C to break
PAUSE > NUL

GOTO start.menu
REM *************************************************************************** Install framework end


REM *************************************************************************** APK file selection start
:filesel
CLS
ECHO ** Application list && ECHO.
ECHO   Folder = %apk.multitoo.root%Files && ECHO. && ECHO.
SET /A count=0
FOR %%F IN (Files/*.apk) DO (
SET /A count+=1
SET a!count!=%%~nF
IF /I !count! LEQ 9 (ECHO ^-  !count! - %%F )
IF /I !count! GTR 9 (ECHO ^- !count! - %%F )
)
ECHO. && ECHO.
SET /P INPUT=Choose the APK file - Enter it's number: %=%
IF /I %INPUT% GTR %count% (GOTO start.menu)
IF /I %INPUT% LSS 1 (GOTO start.menu)
SET apk.name=!a%INPUT%!
ECHO. && ECHO. && ECHO APK SELECTED = %apk.name%.apk
ECHO. && ECHO. && ECHO     # Press any ket to continue or CTRL + C to break
PAUSE >NUL

GOTO start.menu
REM *************************************************************************** APK file selection end


REM *************************************************************************** Decompilation start
:decompile
SET apktool.path=%apk.multitool.root%Program_Files
SET apktool.name=apktool.jar
SET apk.path=%apk.multitool.root%Files
SET apk.source=%apk.name%.apk
SET output.path=%apk.multitool.root%Decompiled_apk\%apk.name%

IF NOT EXIST %apktool.path%\%apktool.name% GOTO decompile.apktool.not.EXIST
IF NOT EXIST %apk.path%\%apk.name%.apk     GOTO decompile.apk.not.EXIST


cls
ECHO ## Decompile apk
ECHO.
ECHO APKTOOL TOOL          = %apktool.path%\%apktool.name%
ECHO APK NAME              = %apk.name%
ECHO SOURCE APK            = %apk.path%\%apk.source%
ECHO DECOMPILED APK FOLDER = %output.path%
ECHO. && ECHO.
ECHO     # Press any ket to continue or CTRL + C to break
PAUSE > NUL


:start
cls
ECHO ## Decompile apk
ECHO.
ECHO APKTOOL JAR           = %apktool.path%\%apktool.name%
ECHO APK NAME              = %apk.name%
ECHO SOURCE APK            = %apk.path%\%apk.source%
ECHO DECOMPILED APK FOLDER = %output.path%
ECHO. && ECHO.

IF EXIST %output.path% (
ECHO ## Cleaning %output.path% folder... && ECHO.
rmdir %output.path% /S /Q >NUL
)

ECHO ## Decompiling %apk.path%\%apk.source%... && ECHO.

SET decompilation.cmdline=-jar %apktool.path%\%apktool.name% d -f -o %output.path% %apk.path%\%apk.source%
IF %log.cmdline%*==1* (
if not exist %log.file% ECHO. > %log.file%
ECHO Decompilation cmdline - %apk.name% >> %log.file%
ECHO java %decompilation.cmdline% >> %log.file%
ECHO. >> %log.file%
)
java %decompilation.cmdline%

GOTO decompile.end

:decompile.apktool.not.EXIST
ECHO. && ECHO %apktool.path%\%apktool.source% not available!
GOTO decompile.end

:decompile.apk.name.empty
ECHO. && ECHO Variable apk.name is empty
GOTO decompile.end

:decompile.apk.not.EXIST
ECHO. && ECHO %apk.path%\%apk.source% not available!
GOTO decompile.end

:decompile.end
ECHO. && ECHO. && ECHO     # Press any key to continue or CTRL + C to break
PAUSE > NUL

SET apktool.path=
SET apktool.name=
SET apk.path=
SET apk.source=
SET output.location=
set decompilation.cmdline=

GOTO start.menu
REM ************************************************************************ Decompilation - End



REM ************************************************************************ Compilation - Start
:compile
SET apktool.path=%apk.multitool.root%Program_Files
SET apktool.name=apktool.jar
SET apk.source.path=%apk.multitool.root%Decompiled_apk
SET apk.compiled.path=%apk.multitool.root%Compiled_apk
SET apk.compiled.name=%apk.name%-unsigned.apk

IF NOT EXIST %apktool.path%\%apktool.name% GOTO compilation.apktool.not.EXIST
IF NOT EXIST %source.path%                 GOTO compilation.source.path.not.EXIST

cls
ECHO ## Compile apk && ECHO.
ECHO APK NAME           = %apk.name%
ECHO APKTOOL JAR        = %apktool.path%\%apktool.name%
ECHO SOURCE FOLDER      = %apk.source.path%\%apk.name%
ECHO DESTINATION APK    = %apk.compiled.path%\%apk.compiled.name%
ECHO. && ECHO.
ECHO     # Press any key to continue or CTRL + C to break
PAUSE > NUL

cls
ECHO ## Compile apk && ECHO.
ECHO APK NAME           = %apk.name%
ECHO APKTOOL JAR        = %apktool.path%\%apktool.name%
ECHO SOURCE FOLDER      = %apk.source.path%\%apk.name%
ECHO DESTINATION APK    = %apk.compiled.path%\%apk.compiled.name%
ECHO. && ECHO.

IF EXIST %apk.compiled.path%\%apk.compiled.name% (
ECHO ## Deleting old %apk.compiled.path%\%apk.compiled.name% file... && ECHO.
DEL %apk.compiled.path%\%apk.compiled.name% >NUL
)

ECHO ## Compiling %apk.compiled.path%\%apk.compiled.name% && ECHO.
SET compilation.cmdline=-jar %apktool.path%\%apktool.name% b -o %apk.compiled.path%\%apk.compiled.name% %apk.source.path%\%apk.name%
IF %log.cmdline%*==1* (
ECHO Compilation cmdline - %apk.name% >> %log.file%
ECHO java %compilation.cmdline% >> %log.file%
ECHO. >> %log.file%
)
java %compilation.cmdline%

if %forced.meta%*==0* GOTO compilation.end
ECHO. && ECHO.
ECHO ## Adding AndroidManIFest.xml file and META-INF folder started... && ECHO.
IF NOT EXIST %apk.source.path%\%apk.name%\original GOTO compilation.error.manIFest
cd Decompiled_apk\%apk.name%\original
..\..\..\Program_Files\7za -tZIP a -y ..\..\..\Compiled_apk\%apk.compiled.name% AndroidManIFest.xml META-INF\*.* > NUL
cd ..\..\..
ECHO ## Adding AndroidManIFest.xml file and META-INF folder completed! && ECHO.
GOTO compilation.end

:compilation.apktool.not.EXIST
ECHO. && ECHO %apktool.location%\%apktool.name% not available!
GOTO compilation.end

:compilation..source.path.not.EXIST
ECHO. && ECHO Source path %apk.source.path% NOT EXIST
GOTO compilation.end

:compilation.error.manIFest
ECHO ** File AndroidManIFest.xml and META-INNF fodler not available
ECHO.
ECHO ** Please remember to copy from original apk the file AndroidManfest.xml
ECHO ** and the content of META-INF folder into the new apk to avoid
ECHO ** bootloop in the apk
ECHO.GOTO compilation.end

:compilation.end
ECHO. && ECHO. && ECHO     # Press any ket to continue or CTRL + C to break
PAUSE > NUL

SET apktool.path=
SET apk.source.path=
SET apk.compiled.path=
SET apk.compiled.name=
SET compilation.cmdline=

GOTO start.menu
REM *************************************************** Compilation - End


REM *************************************************** Sign - Start
:sign

SET sign.apktool.path=%apk.multitool.root%Program_Files
SET sign.apktool.name=signapk.jar
SET certIFicate.path=%apk.multitool.root%Program_Files
SET certIFicate.name=testkey.x509.pem
SET key.path=%apk.multitool.root%Program_Files
SET key.name=testkey.pk8
SET unsigned.apk.path=%apk.multitool.root%Compiled_apk
SET unsigned.apk.name=%apk.name%-unsigned.apk
SET signed.apk.path=%apk.multitool.root%Signed_apk
SET signed.apk.name=%apk.name%-signed.apk

IF NOT EXIST %sign.apktool.path%\%sign.apktool.name%   GOTO sign.apktool.not.EXIST
IF NOT EXIST %certIFicate.path%\%certIFicate.name%     GOTO sign.certIFicate.not.EXIST
IF NOT EXIST %key.path%\%key.name%                     GOTO sign.key.not.EXIST
IF NOT EXIST %unsigned.apk.path%\%unsigned.apk.name%   GOTO sign.unsigned.apk.not.EXIST


cls
ECHO ## Sign apkk
ECHO.
ECHO SIGN TOOL       = %sign.apktool.path%\%sign.apktool.name%
ECHO CERTIFICATE     = %certIFicate.path%\%certIFicate.name%
ECHO KEY             = %key.path%\%key.name%
ECHO.
ECHO APK NAME        = %apk.name%
ECHO UNSIGNED APK    = %unsigned.apk.path%\%unsigned.apk.name%
ECHO SIGNED APK      = %signed.apk.path%\%signed.apk.name%
ECHO. && ECHO.
ECHO     # Press any ket to continue or CTRL + C to break
PAUSE > NUL

cls
ECHO ## Sign apk
ECHO.
ECHO SIGN TOOL       = %sign.apktool.path%\%sign.apktool.name%
ECHO CERTIFICATE     = %certIFicate.path%\%certIFicate.name%
ECHO KEY             = %key.path%\%key.name%
ECHO.
ECHO APK NAME        = %apk.name%
ECHO UNSIGNED APK    = %unsigned.apk.path%\%unsigned.apk.name%
ECHO SIGNED APK      = %signed.apk.path%\%signed.apk.name%
ECHO. && ECHO.

IF EXIST %signed.apk.path%\%signed.apk.name%.apk (
ECHO ## Deleting %signed.apk.path%\%signed.apk.name%... && ECHO. && ECHO.
DEL %signed.apk.path%\%signed.apk.name% >NUL
)

ECHO ## Signing %signed.apk.path%\%signed.apk.name% started... && ECHO.
SET sign.cmdline=-jar %sign.apktool.path%\%sign.apktool.name% -w %certificate.path%\%certificate.name% %key.path%\%key.name% %unsigned.apk.path%\%unsigned.apk.name%  %signed.apk.path%\%signed.apk.name%
IF %log.cmdline%*==1* (
ECHO Signing cmdline - %apk.name% >> %log.file%
ECHO java %sign.cmdline% >> %log.file%
ECHO. >> %log.file%
ECHO. >> %log.file%
)
java %sign.cmdline%

ECHO ## Signing %signed.apk.path%\%signed.apk.name% completed! && ECHO.

GOTO sign.end

:sign.apktool.not.EXIST
ECHO. && ECHO %sign.apk.path%\%sign.apk.name% not available!
GOTO sign.end

:sign.certIFicate.not.EXIST
ECHO. && ECHO %certIFicate.path%\%certIFicate.name% not available!
GOTO sign.end

:sign.key.not.EXIST
ECHO. && ECHO %key.path%\%key.name% not available!
GOTO sign.end

:sign.unsigned.apk.not.EXIST
ECHO. && ECHO %unsigned.apk.path%\%unsigned.apk.name% not available!
GOTO sign.end

:sign.end
ECHO. && ECHO. && ECHO     # Press any key to continue or CTRL + C to break
PAUSE > NUL

SET sign.apktool.path=
SET sign.apktool.name=
SET certIFicate.path=
SET certIFicate.name=
SET key.path=
SET key.name=
SET unsigned.apk.path=
SET unsigned.apk.name=
SET signed.apk.path=
SET signed.apk.name=
SET sign.cmdline=

GOTO start.menu
REM *************************************************** Sign - End


:end
SET sign.apktool.path=
SET sign.apktool.name=
SET certIFicate.path=
SET certIFicate.name=
SET key.path=
SET key.name=
SET unsigned.apk.path=
SET unsigned.apk.name=
SET signed.apk.path=
SET signed.apk.name=
SET forced.meta=0
ENDLOCAL
ECHO. && ECHO.


