@echo off
setlocal enableextensions enabledelayedexpansion
set apk.multitoo.root=C:\AndroidMultiTool\
set apk.name=
:start.menu
CLS
echo **********************************************************
echo *                   Android Multitool                    *
echo **********************************************************
echo.
IF     exist %USERPROFILE%\apktool\framework\1.apk  echo     FRAMEWORK = INSTALLED                && echo.
IF NOT exist %USERPROFILE%\apktool\framework\1.apk  echo     FRAMEWORK = NOT INSTALLED (OPTION 1) && echo.
If %apk.name%*==*                                   echo     APK NAME  = NOT DEFINED (OPTION 2)
If NOT %apk.name%*==*                               echo     APK NAME  = %apk.name%.apk
echo.
echo.
echo   1  = INSTALL FRAMEWORK (framework-res.apk)
echo.
echo   2  = SELECT APK
echo.
echo   3  = DECOMPILE APK
echo.
echo   4  = COMPILE APK
echo.
echo   5  = SIGN APK
echo.
echo.
echo   0  = EXIT
echo.
echo **********************************************************
echo.
SET /P menunr=Select operation: 

IF %menunr%==0 (goto end)
IF %menunr%==1 (goto install-framework)
IF %menunr%==2 (goto filesel)
if %apk.name%*==* goto start.menu
IF %menunr%==3 (goto decompile)
IF %menunr%==4 (goto compile)
IF %menunr%==5 (goto sign)
goto start.menu

REM *************************************************************************** Install framework start
:install-framework
cls
set framework-res.path=Files
set framework-res.file=framework-res.apk

if NOT exist %framework-res.path%\%framework-res.file% goto error-install-framework
call AMT-framework-install.bat with %framework-res.path%\%framework-res.file% && echo.
rem start /MIN Program_Files\apktool if Files\framework-res.apk && echo.
goto end-install-framework

:error-install-framework
echo. && echo ** File %framework-res.path%\%framework-res.file% not available! && echo.

:end-install-framework
echo. && echo. && echo     # Press any ket to continue or CTRL + C to break
PAUSE > NUL

set framework-res.path=Files
set framework-res.file=framework-res.apk
goto start.menu
REM *************************************************************************** Install framework end


REM *************************************************************************** APK file selection start
:filesel
CLS
setlocal EnableDelayedExpansion
ECHO ** Application list && echo.
echo   Folder = %apk.multitoo.root%Files && echo. && echo.
set /A count=0
FOR %%F IN (Files/*.apk) DO (
set /A count+=1
set a!count!=%%~nF
IF /I !count! LEQ 9 (echo ^-  !count! - %%F )
IF /I !count! GTR 9 (echo ^- !count! - %%F )
)
echo. && echo.
set /P INPUT=Choose the APK file - Enter it's number: %=%
IF /I %INPUT% GTR %count% (goto start.menu)
IF /I %INPUT% LSS 1 (goto start.menu)
set apk.name=!a%INPUT%!
echo. && echo. && echo APK SELECTED = %apk.name%.apk
echo. && echo. && echo     # Press any ket to continue or CTRL + C to break
PAUSE >NUL

goto start.menu
REM *************************************************************************** APK file selection end


REM *************************************************************************** Decompilation start
:decompile
SET apktool.path=%apk.multitool.root%Program_Files
SET apktool.name=apktool.jar
SET apk.path=%apk.multitool.root%Files
SET output.path=%apk.multitool.root%Decompiled_apk\%apk.name%

if not exist %apktool.path%\%apktool.name% goto decompile.apktool.not.exist
if not exist %apk.path%\%apk.name%.apk     goto decompile.apk.not.exist


cls
echo ## Decompile apk
echo.
echo APKTOOL TOOL          = %apktool.path%\%apktool.name%
echo SOURCE APK            = %apk.path%\%apk.name%.apk
echo DECOMPILED APK FOLDER = %output.path%
echo. && echo.
echo     # Press any ket to continue or CTRL + C to break
PAUSE > NUL


:start
cls
echo ## Decompile apk
echo.
echo APKTOOL JAR           = %apktool.path%\%apktool.name%
echo SOURCE APK            = %apk.path%\%apk.name%.apk
echo DECOMPILED APK FOLDER = %output.path%
echo. && echo.

if exist %output.path% (
echo ## Cleaning %output.path% folder... && echo.
rmdir %output.path% /S /Q >NUL
)

echo ## Decompiling apk... && echo.

java -jar %apktool.path%\%apktool.name% d -f -o %output.path% %apk.path%\%apk.name%.apk

rem lollipop fix
rem java -jar -Duser.language=en %apktool.path%\%apktool.name% d -f -o %output.path% %apk.path%\%apk.name%.apk

goto decompile.end

:decompile.apktool.not.exist
echo. && echo %apktool.path%\%apktool.name% not available!
goto decompile.end

:decompile.apk.name.empty
echo. && echo Variable apk.name is empty
goto decompile.end

:decompile.apk.not.exist
echo. && echo %apk.path%\%apk.name%.apk not available!
goto decompile.end

:decompile.end
echo. && echo. && echo     # Press any key to continue or CTRL + C to break
PAUSE > NUL

SET apktool.path=
SET apktool.name=
SET apk.path=
SET output.location=

goto start.menu
REM ************************************************************************ Decompilation - End



REM ************************************************************************ Compilation - Start
:compile
SET apktool.path=%apk.multitool.root%Program_Files
SET apktool.name=apktool.jar
SET apk.source.path=%apk.multitool.root%Decompiled_apk
SET apk.compiled.path=%apk.multitool.root%Compiled_apk
SET apk.compiled.name=%apk.name%.apk

if not exist %apktool.path%\%apktool.name% goto compilation.apktool.not.exist
if not exist %source.path%                 goto compilation.source.path.not.exist

cls
echo ## Compile apk && echo.
echo APKTOOL JAR        = %apktool.path%\%apktool.name%
echo SOURCE FOLDER      = %apk.source.path%\%apk.name%
echo DESTINATION APK    = %apk.compiled.path%\%apk.compiled.name%
echo. && echo.
echo     # Press any key to continue or CTRL + C to break
PAUSE > NUL

cls
echo ## Compile apk && echo.
echo APKTOOL JAR        = %apktool.path%\%apktool.name%
echo SOURCE FOLDER      = %apk.source.path%\%apk.name%
echo DESTINATION APK    = %apk.compiled.path%\%apk.compiled.name%.apk
echo. && echo.

if exist %apk.compiled.path%\%apk.compiled.name% (
echo ## Deleting old %apk.compiled.path%\%apk.compiled.name% file... && echo.
del %apk.compiled.path%\%apk.compiled.name% >NUL
)

echo ## Compiling %apk.compiled.path%\%apk.compiled.name% && echo.
java -jar %apktool.path%\%apktool.name% b -o %apk.compiled.path%\%apk.compiled.name% %apk.source.path%\%apk.name%

echo. && echo.
echo ## Adding AndroidManifest.xml file and META-INF folder started... && echo.
IF NOT exist %apk.source.path%\%apk.name%\original goto compilation.error.manifest
cd Decompiled_apk\%apk.name%\original
..\..\..\Program_Files\7za -tZIP a -y ..\..\..\Compiled_apk\%apk.compiled.name% AndroidManifest.xml META-INF\*.* > NUL
cd ..\..\..
echo ## Adding AndroidManifest.xml file and META-INF folder completed! && echo.
goto compilation.end

:compilation.apktool.not.exist
echo. && echo %apktool.location%\%apktool.name% not available!
goto compilation.end

:compilation..source.path.not.exist
echo. && echo Source path %apk.source.path% not exist
goto compilation.end

:compilation.error.manifest
echo ** File AndroidManifest.xml and META-INNF fodler not available
echo.
echo ** Please remember to copy from original apk the file AndroidManfest.xml
echo ** and the content of META-INF folder into the new apk to avoid
echo ** bootloop in the apk
echo.goto compilation.end

:compilation.end
echo. && echo. && echo     # Press any ket to continue or CTRL + C to break
PAUSE > NUL

SET apktool.path=
SET apk.source.path=
SET apk.compiled.path=
set apk.compiled.name=


goto start.menu
REM *************************************************** Compilation - End


REM *************************************************** Sign - Start
:sign

SET sign.apktool.path=%apk.multitool.root%Program_Files
SET sign.apktool.name=signapk.jar
SET certificate.path=%apk.multitool.root%Program_Files
SET certificate.name=testkey.x509.pem
SET key.path=%apk.multitool.root%Program_Files
SET key.name=testkey.pk8
SET unsigned.apk.path=%apk.multitool.root%Compiled_apk
set unsigned.apk.name=%apk.name%
SET signed.apk.path=%apk.multitool.root%Signed_apk
SET signed.apk.name=%unsigned.apk.name%

if not exist %sign.apktool.path%\%sign.apktool.name%      goto sign.apktool.not.exist
if not exist %certificate.path%\%certificate.name%        goto sign.certificate.not.exist
if not exist %key.path%\%key.name%                        goto sign.key.not.exist
if not exist %unsigned.apk.path%\%unsigned.apk.name%.apk  goto sign.unsigned.apk.not.exist


cls
echo ## Sign apkk
echo.
echo SIGN TOOL       = %sign.apktool.path%\%sign.apktool.name%
echo CERTIFICATE     = %certificate.path%\%certificate.name%
echo KEY             = %key.path%\%key.name%
echo.
echo UNSIGNED APK    = %unsigned.apk.path%\%unsigned.apk.name%.apk
echo SIGNED APK      = %signed.apk.path%\%signed.apk.name%.apk
echo. && echo.
echo     # Press any ket to continue or CTRL + C to break
PAUSE > NUL

cls
echo ## Sign apk
echo.
echo SIGN TOOL       = %sign.apktool.path%\%sign.apktool.name%
echo CERTIFICATE     = %certificate.path%\%certificate.name%
echo KEY             = %key.path%\%key.name%
echo.
echo UNSIGNED APK    = %unsigned.apk.path%\%unsigned.apk.name%.apk
echo SIGNED APK      = %signed.apk.path%\%signed.apk.name%.apk
echo. && echo.

if exist %signed.apk.path%\%signed.apk.name%.apk (
echo ## Deleting %signed.apk.path%\%signed.apk.name%.apk... && echo. && echo.
del %signed.apk.path%\%signed.apk.name%.apk >NUL
)

echo ## Signing %signed.apk.path%\%signed.apk.name%.apk... && echo.
java -jar %sign.apktool.path%\%sign.apktool.name% -w %certificate.path%\%certificate.name% %key.path%\%key.name% %unsigned.apk.path%\%unsigned.apk.name%.apk  %signed.apk.path%\%signed.apk.name%.apk

echo ## Sign %signed.apk.path%\%signed.apk.name%.apk completed! && echo.

goto sign.end

:sign.apktool.not.exist
echo. && echo %sign.apk.path%\%sign.apk.name% not available!
goto sign.end

:sign.certificate.not.exist
echo. && echo %certificate.path%\%certificate.name% not available!
goto sign.end

:sign.key.not.exist
echo. && echo %key.path%\%key.name% not available!
goto sign.end

:sign.unsigned.apk.not.exist
echo. && echo %unsigned.apk.path%\%unsigned.apk.name% not available!
goto sign.end

:sign.end
echo. && echo. && echo     # Press any key to continue or CTRL + C to break
PAUSE > NUL

SET sign.apktool.path=
SET sign.apktool.name=
SET certificate.path=
SET certificate.name=
SET key.path=
SET key.name=
SET unsigned.apk.path=
set unsigned.apk.name=
SET signed.apk.path=
SET signed.apk.name=

goto start.menu
REM *************************************************** Sign - End


:end
SET sign.apktool.path=
SET sign.apktool.name=
SET certificate.path=
SET certificate.name=
SET key.path=
SET key.name=
SET unsigned.apk.path=
set unsigned.apk.name=
SET signed.apk.path=
SET signed.apk.name=
echo. && echo.


